<?php

namespace App\Controllers;

use App\Libraries\TimeHelper;
use App\Libraries\PasswordVerify;
use App\Libraries\EmailService;

use App\Models\PanelModel;
use App\Models\FavouriteModel;
use App\Models\BannerModel;
use App\Models\HomeSectionsModel;
use App\Models\CategoryModel;
use App\Models\CountriesModel;
use App\Models\PodcastModel;
use App\Models\RadioViewsModel;
use App\Models\RadioModel;
use App\Models\SubscriptionModel;
use App\Models\ReportsModel;
use App\Models\SuggestModel;
use App\Models\RatingModel;
use App\Models\UsersModel;
use App\Models\ActiveLogModel;
use App\Models\EpisodeModel;
use App\Models\NotificationModel;

class ApiController extends BaseController {
    
    protected $apiHeader;

    public function __construct(){
        $this->apiHeader = getenv('API_HEADER_APP');
        $panelModel = new PanelModel();
        $this->settings = $panelModel->getSettings();
        $this->favourite = new FavouriteModel();
    }
    
    public function index() {
        
        // Purchase code verification
        if (!$this->isPurchaseCodeValid()) { 
            $set[$this->apiHeader][]=array('MSG'=> 'Purchase code verification failed!','success'=>'0');
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        
        // Check if 'data' is provided in the POST request
        $data = $this->request->getPost('data');
        if (!$data) {
            $set[$this->apiHeader][]=array('MSG'=> 'Missing data parameter!','success'=>'0');
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        
        $get_helper = $this->getApiData($data);
        if($get_helper['helper_name'] == "get_home"){
            
            $home_limit = isset($this->settings['home_limit']) ? (int) $this->settings['home_limit'] : 10; // Default to 10 if not set
            
            $user_id = $get_helper['user_id'] ?? 0;
            $ids=isset($get_helper['radio_ids']) ? trim($get_helper['radio_ids']) : 0;
            
            $radioModel = new RadioModel();
            $bannerModel = new BannerModel();
            
            $dataBanner = $bannerModel->orderBy('bid', 'DESC')->where('status', 1)->findAll();
            $row['slider'] = $this->getBannerList($dataBanner);
            
            $builder = $radioModel->select('tbl_radio.*, tbl_category.category_name')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                ->whereIn('tbl_radio.id', explode(',', $ids))
                ->where('tbl_radio.status', 1)
                ->where('tbl_category.status', 1)
                ->orderBy('tbl_radio.id', 'DESC')
                ->limit($home_limit);
            
            // Execute query
            $recentlyRadios = $builder->findAll();
            $row['recently_radio'] = $this->getRadioList($recentlyRadios, $user_id);
            
            $latestRadios = $radioModel->getLatestRadio($home_limit);
            $row['latest_radio'] = $this->getRadioList($latestRadios, $user_id);
            
            $trendingRadios = $radioModel->getTrendingRadios($home_limit);
            $row['trending_radio'] = $this->getRadioList($trendingRadios, $user_id);
            
            $jsonObj= array();
            $data_arr= array();
            
            $sectionsModel = new HomeSectionsModel();
            $sections = $sectionsModel->orderBy('id', 'DESC')->where('status', 1)->findAll();
            if (!empty($sections)) {
                foreach ($sections as $data) {
                    $id_list = explode(",", $data['post_ids']);
                    
                    if($data['section_type']=="category"){
                        $categoryModel = new CategoryModel();
                        $category = $categoryModel->whereIn('cid', $id_list)->where('status', 1)->orderBy('cid', 'DESC')->limit($home_limit)->findAll();
                        if (!empty($category)) {
                            foreach ($category as $data01) {
                                $home_content1[]= array(
                                    "post_id"=>$data01['cid'],
                                    "post_title"=>$data01['category_name'],
                                    "post_image"=> base_url('images/'.$data01['category_image'])
                                );
                            }
                            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$home_content1);
                            unset($home_content1);
                        }
                    } else if($data['section_type']=="countries"){
                        $countriesModel = new CountriesModel();
                        $countries = $countriesModel->whereIn('sid', $id_list)->where('status', 1)->orderBy('sid', 'DESC')->limit($home_limit)->findAll();
                        if (!empty($countries)) {
                            foreach ($countries as $data02) {
                                $home_content2[]= array(
                                    "post_id"=>$data02['sid'],
                                    "post_title"=>$data02['countries_name'],
                                    "post_image"=> base_url('images/'.$data02['countries_image'])
                                );
                            }
                            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$home_content2);
                            unset($home_content2);
                        }
                    } else if($data['section_type']=="podcasts"){
                        $podcastModel = new PodcastModel();
                        $podcast = $podcastModel->whereIn('pid', $id_list)->where('status', 1)->orderBy('pid', 'DESC')->limit($home_limit)->findAll();
                        if (!empty($podcast)) {
                            foreach ($podcast as $data03) {
                                $home_content3[]= array(
                                    "post_id"=>$data03['pid'],
                                    "post_title"=> $data03['podcast_name'],
                                    "post_image"=> base_url('images/'.$data03['podcast_image'])
                                );
                            }
                            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$home_content3);
                            unset($home_content3);
                        }
                    } else if($data['section_type']=="radio"){
                        $radioModel = new RadioModel();
            	        $recentlyRadios = $radioModel->getRecentlyRadio($id_list, $home_limit);
            	        if (!empty($recentlyRadios)) {
                            $home_content5 = $this->getRadioList($recentlyRadios, $user_id);
                            $row['home_sections'][]=array("home_id"=>$data['id'],"home_title"=>$data['section_name'],"home_type"=>$data['section_type'],"home_content"=>$home_content5);
                            unset($home_content5);
                        }
                    }
                }
            }
            $set[$this->apiHeader] = $row;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        } 
        else if($get_helper['helper_name'] == "home_collections"){
            
            $user_id = $get_helper['user_id'] ?? 0;
            $sections_id=isset($get_helper['id']) ? trim($get_helper['id']) : 0;
            
            $jsonObj = [];
            
            $sectionsModel = new HomeSectionsModel();
            $section = $sectionsModel->where('id', $sections_id)->where('status', '1')->orderBy('id', 'DESC')->first();
            if (!empty($section)) {
                $id_list = explode(",", $section['post_ids']);
                
                if($section['section_type']=="category"){
                    $categoryModel = new CategoryModel();
                    $categories = $categoryModel->whereIn('cid', $id_list)->where('status', 1)->orderBy('cid', 'DESC')->findAll();
                    if (!empty($categories)) {
                        foreach ($categories as $data01) {
                            $jsonObj[] = [
                                'cid' => $data01['cid'],
                                'countries_name' => $data01['category_name'],
                                'countries_image' => base_url('images/' . $data01['category_image'])
                            ];
                        }
                    }
                } else if($section['section_type']=="countries"){
                    $countriesModel = new CountriesModel();
                    $countries = $countriesModel->whereIn('sid', $id_list)->where('status', 1)->orderBy('sid', 'DESC')->findAll();
                    if (!empty($countries)) {
                        foreach ($countries as $data02) {
                            $jsonObj[] = [
                                'cid' => $data02['sid'],
                                'countries_name' => $data02['countries_name'],
                                'countries_image' => base_url('images/' . $data02['countries_image'])
                            ];
                        }
                    }
                } else if($section['section_type']=="podcasts"){
                    $podcastModel = new PodcastModel();
                    $podcast = $podcastModel->whereIn('pid', $id_list)->where('status', 1)->orderBy('pid', 'DESC')->findAll();
                    if (!empty($podcast)) {
                        foreach ($podcast as $data03) {
                            $jsonObj[] = [
                                'pid' => $data03['pid'],
                                'podcast_name' => $data03['podcast_name'],
                                'podcast_image' => base_url('images/' . $data03['podcast_image'])
                            ];
                        }
                    }
                } else if($section['section_type']=="radio"){
                    $radioModel = new RadioModel();
        	        $recentlyRadios = $radioModel->getRecentlyRadio($id_list, null);
        	        $jsonObj = $this->getRadioList($recentlyRadios, $user_id);
                }
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "get_latest"){
    
            $jsonObj = [];
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            
            $page_limit=10;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            $radioModel = new RadioModel();
            $result = $radioModel
                ->select('tbl_radio.id, tbl_radio.cat_id, tbl_radio.radio_title, tbl_radio.radio_url, tbl_radio.radio_image, 
                         tbl_radio.rate_avg, tbl_radio.total_rate, tbl_category.category_name, tbl_radio.total_views, tbl_radio.isPremium')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid')
                ->where('tbl_radio.status', 1)
                ->where('tbl_category.status', 1)
                ->orderBy('tbl_radio.id', 'DESC')
                ->limit($page_limit, $limit)
                ->findAll();
                
            $jsonObj = $this->getRadioList($result, $user_id);

            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "get_trending_radio"){
    
            $jsonObj = [];
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            
            $radioModel = new RadioModel();
	        $result = $radioModel->getTrendingRadios('25');
	        $jsonObj = $this->getRadioList($result, $user_id);
	        
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "cat_list"){
            
            $search_text=addslashes(trim($get_helper['search_text']));
            $search_type=trim($get_helper['search_type']);
            
            $jsonObj = [];
            
            $page_limit=15;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $model = new CategoryModel();
            
            // Start query builder
            $builder = $model->where('status', 1);
            
            // If search type is 'search', add search condition
            if ($search_type == 'search' && !empty($search_text)) {
                $builder->like('category_name', $search_text);
            }
            
            // Set ordering and limit
            $builder->orderBy('cid', 'DESC')->limit($page_limit, $limit);
            
            // Execute query
            $result = $builder->findAll();
            
            if (!empty($result)) {
                foreach ($result as $data) {
                    $jsonObj[] = [
                        'cid'            => $data['cid'],
                        'category_name'  => $data['category_name'],
                        'category_image' => base_url('images/'.$data['category_image'])
                    ];
                }
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "cou_list"){
            
            $search_text=addslashes(trim($get_helper['search_text']));
            $search_type=trim($get_helper['search_type']);
            
            $jsonObj = [];
            
            $page_limit=15;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $model = new CountriesModel();
            
            // Start query builder
            $builder = $model->where('status', 1);
            
            // If search type is 'search', add search condition
            if ($search_type == 'search' && !empty($search_text)) {
                $builder->like('countries_name', $search_text);
            }
            
            // Set ordering and limit
            $builder->orderBy('sid', 'DESC')->limit($page_limit, $limit);
            
            // Execute query
            $result = $builder->findAll();
            
            if (!empty($result)) {
                foreach ($result as $data) {
                    $jsonObj[] = [
                        'cid'             => $data['sid'],
                        'countries_name'  => $data['countries_name'],
                        'countries_image' => base_url('images/'.$data['countries_image'])
                    ];
                }
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "podcasts_list"){
            
            $search_text=addslashes(trim($get_helper['search_text']));
            $search_type=trim($get_helper['search_type']);
            
            $jsonObj = [];
            
            $page_limit=15;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $model = new PodcastModel();
            
            // Start query builder
            $builder = $model->where('status', 1);
            
            // If search type is 'search', add search condition
            if ($search_type == 'search' && !empty($search_text)) {
                $builder->like('podcast_name', $search_text);
            }
            
            // Set ordering and limit
            $builder->orderBy('pid', 'DESC')->limit($page_limit, $limit);
            
            // Execute query
            $result = $builder->findAll();
            
            if (!empty($result)) {
                foreach ($result as $data) {
                    $jsonObj[] = [
                        'pid'           => $data['pid'],
                        'podcast_name'  => $data['podcast_name'],
                        'podcast_image' => base_url('images/'.$data['podcast_image'])
                    ];
                }
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "get_recent_radio"){
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            $ids=trim($get_helper['radio_ids']);
            
            $jsonObj = [];
            
            $page_limit=15;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $radioModel = new RadioModel();
            
            $builder = $radioModel->select('tbl_radio.*, tbl_category.category_name')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                ->whereIn('tbl_radio.id', explode(',', $ids))
                ->where('tbl_radio.status', 1)
                ->where('tbl_category.status', 1)
                ->orderBy('tbl_radio.id', 'DESC')
                ->limit($page_limit, $limit);
            
            // Execute query
            $result = $builder->findAll();
            
            $jsonObj = $this->getRadioList($result, $user_id);
            
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "single_radio"){
            
            $response=array();
            
            $radioModel = new RadioModel();
            $radioViewsModel = new RadioViewsModel();
            
            // Increment the views for the radio
            $song_id = $get_helper['radio_id'];
            $radioModel->set('total_views', 'total_views + 1', false)
            ->where('id', $song_id)
            ->update();
            
            $date = date('Y-m-d');
            $start = (date('D') != 'Mon') ? date('Y-m-d', strtotime('last Monday')) : date('Y-m-d');
            $finish = (date('D') != 'Sat') ? date('Y-m-d', strtotime('next Saturday')) : date('Y-m-d');
    

        	// Check if views already exist for the current week
            $viewExists = $radioViewsModel
                ->where('radio_id', $song_id)
                ->where('date >=', $start)
                ->where('date <=', $finish)
                ->first();
        
        	if ($viewExists) {
                // If view exists, update the views count
                $radioViewsModel->set('views', 'views + 1', false)
                                ->where('radio_id', $song_id)
                                ->where('date >=', $start)
                                ->where('date <=', $finish)
                                ->update();
                
                $response = ['MSG' => 'update', 'success' => '1'];
            } else {
                // If no view exists, insert a new view record
                $viewExistsForSong = $radioViewsModel->where('radio_id', $song_id)->first();
                if ($viewExistsForSong) {
                    // Delete the old view records if any exist
                    $radioViewsModel->where('radio_id', $song_id)->delete();
                }
        
                // Insert a new view record for the song
                $data = [
                    'radio_id' => $song_id,
                    'views' => 1,
                    'date' => $date
                ];
                $radioViewsModel->insert($data);
                
                $response = ['MSG' => 'added', 'success' => '1'];
            }
        	$set[$this->apiHeader][]=$response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "get_search_radio"){
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            $search_text=addslashes(trim($get_helper['search_text']));
            
            $jsonObj = [];
            
            $page_limit=15;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $radioModel = new RadioModel();
            
            $builder = $radioModel->select('tbl_radio.*, tbl_category.category_name')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                ->like('tbl_radio.radio_title', $search_text)
                ->where('tbl_radio.status', 1)
                ->where('tbl_category.status', 1)
                ->orderBy('tbl_radio.radio_title', 'DESC')
                ->limit($page_limit, $limit);
            
            // Execute query
            $result = $builder->findAll();
            
            $jsonObj = $this->getRadioList($result, $user_id);
            
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "get_podcasts_by"){

            $jsonObj = [];
            
            $podcastId =  $get_helper['podcasts_id'];
            
            $page_limit=10;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $model = new EpisodeModel();
            
            $result = $model->select('tbl_episode.id, tbl_episode.podcast_id, tbl_episode.episode_title, tbl_episode.episode_url, tbl_podcast.podcast_name, tbl_podcast.podcast_image')
                ->join('tbl_podcast', 'tbl_episode.podcast_id = tbl_podcast.pid', 'left')
                ->where('tbl_episode.podcast_id', $podcastId)
                ->where('tbl_episode.status', '1')
                ->orderBy('tbl_episode.id', 'DESC')
                ->limit($page_limit, $limit)
                ->findAll();
            
            if (!empty($result)) {
               foreach ($result as $data) {
                   $jsonObj[] = [
                        'id'            => $data['id'],
                        'podcast_id'    => $data['podcast_id'],
                        'episode_title' => $data['episode_title'],
                        'episode_url'   => $data['episode_url'],
                        'podcast_name'  => $data['podcast_name'],
                        'podcast_image' => base_url('images/'.$data['podcast_image']),
                    ];
                }
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "cat_radio") {

            $jsonObj = [];
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            $cat_id = $get_helper['cat_id'];
            
            $page_limit = 10;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $model = new RadioModel();
            
            $result = $model->select('tbl_radio.id, tbl_radio.cat_id, tbl_radio.radio_title, tbl_radio.radio_url, tbl_radio.radio_image, tbl_radio.rate_avg, tbl_radio.total_rate, tbl_radio.total_views, tbl_radio.isPremium, tbl_category.category_name')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                ->where('tbl_radio.cat_id', $cat_id)
                ->where('tbl_radio.status', '1')
                ->where('tbl_category.status', '1')
                ->orderBy('tbl_radio.id', 'DESC')
                ->limit($page_limit, $limit)
                ->findAll();
            
            $jsonObj = $this->getRadioList($result, $user_id);

            $set[$this->apiHeader] = $jsonObj;
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            die();
        }
        else if($get_helper['helper_name'] == "cou_radio") {
        
            $jsonObj = [];
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            $cou_id = $get_helper['cou_id'];
            
            $page_limit = 10;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Model
            $model = new RadioModel();
            
            $result = $model->select('tbl_radio.id, tbl_radio.cat_id, tbl_radio.radio_title, tbl_radio.radio_url, tbl_radio.radio_image, tbl_radio.rate_avg, tbl_radio.total_rate, tbl_radio.total_views, tbl_radio.isPremium, tbl_category.category_name')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                ->where('tbl_radio.countries_id', $cou_id)
                ->where('tbl_radio.status', '1')
                ->where('tbl_category.status', '1')
                ->orderBy('tbl_radio.id', 'DESC')
                ->limit($page_limit, $limit)
                ->findAll();
                
            $jsonObj = $this->getRadioList($result, $user_id);
            
            $set[$this->apiHeader] = $jsonObj;
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            die();
        }
        else if($get_helper['helper_name'] == "banner_radio") {
        
            $jsonObj = [];
        
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            $banner_id = $get_helper['banner_id'];
        
            // Load Banner Model
            $bannerModel = new BannerModel();
            $banner = $bannerModel->select('banner_post_id')
                                  ->where('status', '1')
                                  ->where('bid', $banner_id)
                                  ->orderBy('bid', 'DESC')
                                  ->first();
                                  
            if (!empty($banner)) {
                $radio_ids = trim($banner['banner_post_id']);
                
                if (!empty($radio_ids)) {
                    $page_limit = 15;
                    $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
                    
                    // Load Radio Model
                    $radioModel = new RadioModel();
                    
                    $result = $radioModel->select('tbl_radio.id, tbl_radio.cat_id, tbl_radio.radio_title, tbl_radio.radio_url, tbl_radio.radio_image, tbl_radio.rate_avg, tbl_radio.total_rate, tbl_radio.total_views, tbl_radio.isPremium, tbl_category.category_name')
                        ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                        ->whereIn('tbl_radio.id', explode(',', $radio_ids))
                        ->where('tbl_radio.status', '1')
                        ->where('tbl_category.status', '1')
                        ->orderBy('tbl_radio.id', 'DESC')
                        ->limit($page_limit, $limit)
                        ->findAll();
                        
                    $jsonObj = $this->getRadioList($result, $user_id);
                }
            }
            $set[$this->apiHeader] = $jsonObj;
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            die();
        }
        else if($get_helper['helper_name'] == "get_search") {
        
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            $search_text = $get_helper['search_text'];
            
            $jsonObj = [];
            $row = [];
            
            // Load models
            $radioModel = new RadioModel();
            $categoryModel = new CategoryModel();
            $countryModel = new CountriesModel();
            $podcastModel = new PodcastModel();
        
            // Search for Radios
            $radioResults = $radioModel->select('tbl_radio.id, tbl_radio.cat_id, tbl_radio.radio_title, tbl_radio.radio_url, tbl_radio.radio_image, tbl_radio.rate_avg, tbl_radio.total_rate, tbl_radio.total_views, tbl_radio.isPremium, tbl_category.category_name')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                ->like('tbl_radio.radio_title', $search_text)
                ->where('tbl_radio.status', '1')
                ->where('tbl_category.status', '1')
                ->orderBy('tbl_radio.radio_title', 'DESC')
                ->findAll();

            $row['radio_list'] = $this->getRadioList($radioResults, $user_id);
        
            // Search for Categories
            $categoryResults = $categoryModel->select('cid, category_name, category_image')
                ->like('category_name', $search_text)
                ->where('status', '1')
                ->orderBy('category_name', 'DESC')
                ->findAll();
        
            $categoryList = [];
            if (!empty($categoryResults)) {
                foreach ($categoryResults as $data) {
                    $categoryList[] = [
                        'post_id'    => $data['cid'],
                        'post_title' => $data['category_name'],
                        'post_image' => base_url('images/' . $data['category_image']),
                    ];
                }
            }
            $row['category_list'] = $categoryList;
        
            // Search for Countries
            $countryResults = $countryModel->select('sid, countries_name, countries_image')
                ->like('countries_name', $search_text)
                ->where('status', '1')
                ->orderBy('countries_name', 'DESC')
                ->findAll();
        
            $countryList = [];
            if (!empty($countryResults)) {
                foreach ($countryResults as $data) {
                    $countryList[] = [
                        'post_id'    => $data['sid'],
                        'post_title' => $data['countries_name'],
                        'post_image' => base_url('images/' . $data['countries_image']),
                    ];
                }
            }
            $row['countries_list'] = $countryList;
        
            // Search for Podcasts
            $podcastResults = $podcastModel->select('pid, podcast_name, podcast_image')
                ->like('podcast_name', $search_text)
                ->where('status', '1')
                ->orderBy('podcast_name', 'DESC')
                ->findAll();
        
            $podcastList = [];
            if (!empty($podcastResults)) {
                foreach ($podcastResults as $data) {
                    $podcastList[] = [
                        'post_id'    => $data['pid'],
                        'post_title' => $data['podcast_name'],
                        'post_image' => base_url('images/' . $data['podcast_image']),
                    ];
                }
            }
            $row['podcasts_list'] = $podcastList;
        
            // Prepare API response
            $set[$this->apiHeader] = $row;
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            die();
        }
        else if($get_helper['helper_name'] == "favourite_post") {
        
            $response = [];
            
            $user_id = $get_helper['user_id'];
            $post_id = $get_helper['post_id'];
            
            // Check if the favourite entry already exists
            $exists = $this->favourite->where('post_id', $post_id)->where('user_id', $user_id)->first();
            
            if (!$exists) {
                // Insert new favourite
                $data = [
                    'post_id'    => $post_id,
                    'user_id'    => $user_id,
                    'type'       => 'radio',
                    'created_at' => strtotime(date('d-m-Y h:i:s A')), 
                ];
                $this->favourite->insert($data);
                
                $response = ['MSG' => "Added to Favourite", 'success' => '1'];
            } else {
                // Remove favourite
                if ($this->favourite->where('post_id', $post_id)->where('user_id', $user_id)->delete()) {
                    $response = ['MSG' => "Removed from Favourite", 'success' => '0'];
                } else {
                    $response = ['MSG' => "Error in remove from Favourite", 'success' => '1'];
                }
            }
            $set[$this->apiHeader][] = $response;
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            die();
        }
        else if($get_helper['helper_name'] == "get_favourite") {

            $jsonObj = [];
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            
            $page_limit = 10;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            // Load Models
            $radioModel = new RadioModel();
            $favouriteModel = new FavouriteModel();
            $categoryModel = new CategoryModel();
        
            // Get favourite radio stations
            $result = $radioModel->select('tbl_radio.*, tbl_category.category_name')
                ->join('tbl_favourite', 'tbl_radio.id = tbl_favourite.post_id', 'left')
                ->join('tbl_category', 'tbl_radio.cat_id = tbl_category.cid', 'left')
                ->where('tbl_radio.status', 1)
                ->where('tbl_category.status', 1)
                ->where('tbl_favourite.user_id', $user_id)
                ->orderBy('tbl_favourite.id', 'DESC')
                ->limit($page_limit, $limit)
                ->findAll();
                
            $jsonObj = $this->getRadioList($result, $user_id);
            
            $set[$this->apiHeader] = $jsonObj;
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            die();
        }
        else if($get_helper['helper_name'] == "subscription_list"){
            
         	$jsonObj = [];
         	
         	$subscriptionModel = new SubscriptionModel();
            $subscription = $subscriptionModel->orderBy('id', 'DESC')->findAll();
            if (!empty($subscription)) {
                foreach ($subscription as $data) {
                    $jsonObj[] = [
                        'id'              =>  $data['id'],
                        'plan_name'       =>  $data['name'],
                        'plan_duration'   =>  $data['duration'],
                        'plan_price'      =>  $data['price'],
                        'currency_code'   =>  $data['currency_code'],
                        'subscription_id' =>  $data['subscription_id'],
                        'base_key'        =>  $data['base_key']
                    ];
                }
            }
        	$set[$this->apiHeader] = $jsonObj;
        	header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        	die();
        }
        else if($get_helper['helper_name'] == "post_report") {

            $response = [];
 
            $post_id = isset($get_helper['post_id']) ? $get_helper['post_id'] : 0;
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            $report_title = isset($get_helper['report_title']) ? $get_helper['report_title'] : '';
            $report_msg = isset($get_helper['report_msg']) ? $get_helper['report_msg'] : '';

            // Insert Report
            $report_data = [
                'post_id' => $post_id,
                'user_id' => $user_id,
                'report_title' => $report_title,
                'report_msg' => $report_msg,
                'report_on' => strtotime(date('d-m-Y h:i:s A')),
            ];
            
            $reports = new ReportsModel();
            $reports->insert($report_data);
            
            // Insert Notification
            $notification_data = [
                'user_id' => $user_id,
                'notification_title' => 'Report Submitted',
                'notification_msg' => $report_msg,
                'notification_on' => strtotime(date('d-m-Y h:i:s A')),
            ];
            $notification = new NotificationModel();
            $notification->insert($notification_data);
                
            $response = ['MSG' => 'Report submitted successfully.', 'success' => '1'];
            $set[$this->apiHeader][] = $response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "post_suggest"){	
    
        	$user_id = $get_helper['user_id'];
        	$suggest_title = $get_helper['suggest_title'];
        	$suggest_message = $get_helper['suggest_message'];
            	
            $image_data = $this->handleImageUpload();
            
        	$data = array(
                'user_id'  =>  $user_id,
                'suggest_title'  =>  $suggest_title,
                'suggest_image'  =>  $image_data,
                'suggest_message'  =>  $suggest_message,
                'suggest_on'  =>  strtotime(date('d-m-Y h:i:s A')), 
            );
            $suggest = new SuggestModel();
            $suggest->insert($data);
            
            // Insert Notification
            $notification_data = [
                'user_id'            => $user_id,
                'notification_title' => 'Suggest Submitted',
                'notification_msg'   => $suggest_message,
                'notification_on'    => strtotime(date('d-m-Y h:i:s A')) 
            ];
            $notification = new NotificationModel();
            $notification->insert($notification_data);
            
            $set[$this->apiHeader][]=array('MSG'=> 'Suggest submitted successfully.','success'=> '1');
          	header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        	die();
        }
        
        // Rating --------------------------------------------------------------
        else if($get_helper['helper_name'] == "get_rating"){
    
            $jsonObj= array();	
            
            $post_id = $get_helper['post_id'];
            $device_id = $get_helper['device_id'];
            
            $ratingModel = new RatingModel();
            $data = $ratingModel->where(['post_id' => $post_id, 'device_id' => $device_id])->first();
            if ($data) {
            	$jsonObj = array( 'total_rate' => $data['rate'] , 'message' => $data['message']);	
            } else {
            	$jsonObj = array( 'total_rate' => 0, 'message' => '');
            }
            
            $set[$this->apiHeader][] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "post_rating"){
    
            $jsonObj= array();	
            
            $post_id = $get_helper['post_id'];
            $device_id = $get_helper['device_id'];
            $therate = $get_helper['rate'];
            $message = $get_helper['message'];
            
            $ratingModel = new RatingModel();
            $radioModel  = new RadioModel();
            
            $existingRating = $ratingModel->where(['post_id' => $post_id, 'device_id' => $device_id])->first();
            if (!$existingRating) {
                
                $data = array(   
                    'post_id' => $post_id,
                    'device_id' => $device_id,
                    'rate' => $therate,
                    'message' => addslashes($message)
                );
                $ratingModel->insert($data);
                
                $allRatings = $ratingModel->where('post_id', $post_id)->findAll();
                $rateTimes  = count($allRatings);
                $sumRates   = array_sum(array_column($allRatings, 'rate'));
                
                $rateAvg = ($rateTimes > 0) ? round($sumRates / $rateTimes) : 0;
                
                // Update radio rating
                $radioModel->update($post_id, [
                    'total_rate' => $rateTimes,
                    'rate_avg'   => $rateAvg
                ]);
                $updatedRadio = $radioModel->find($post_id);
                
                $jsonObj = array('total_rate' => $updatedRadio['total_rate'],'rate_avg' => $updatedRadio['rate_avg'],'MSG' => 'You have successfully rated','success'=> '1');
            } else {
                $jsonObj = array('MSG' => 'You have already rated !','success'=> '0');
            }
            $set[$this->apiHeader][] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        
        // Notification --------------------------------------------------------
        else if($get_helper['helper_name'] == "get_notification") {
            $jsonObj = [];
            
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            
            $page_limit=10;
            $limit = $this->getPaginationLimit($get_helper['page'], $page_limit);
            
            $model = new NotificationModel();
            $result = $model->where('user_id', $user_id)->orderBy('id', 'DESC')->findAll($page_limit, $limit); 
            if (!empty($result)) {
               foreach ($result as $data) {
                   $jsonObj[] = [
                        'id'                 => $data['id'],
                        'notification_title' => $data['notification_title'],
                        'notification_msg'   => $data['notification_msg'],
                        'notification_on'    => $data['notification_on']
                    ];
                }
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "remove_notification"){
            
            $jsonObj = [];
            
            $post_id = isset($get_helper['post_id']) ? $get_helper['post_id'] : 0;
            $user_id = isset($get_helper['user_id']) ? $get_helper['user_id'] : 0;
            
            $notificationModel = new NotificationModel();
            $notification = $notificationModel->where('id', $post_id)->where('user_id', $user_id)->first();
            if ($notification) {
                $notificationModel->delete($post_id);
                $jsonObj[] = ['MSG' => "Remove successfully.", 'success' => '1'];
            } else {
                $jsonObj[] = ['MSG' => "Error",'success' => '0'];
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        
        // Users ---------------------------------------------------------------
        else if($get_helper['helper_name'] == "user_register"){
            
            $response = [];
            
            $user_type = isset($get_helper['type']) ? trim($get_helper['type']) : '';
            $email = isset($get_helper['user_email']) ? addslashes(trim($get_helper['user_email'])) : '';
            $user_name = isset($get_helper['user_name']) ? $get_helper['user_name'] : '';
            $user_id = '';
            
            $usersModel = new UsersModel();
            
            if($user_type == 'Google'){
                
                $auth_id = isset($get_helper['auth_id']) ? addslashes(trim($get_helper['auth_id'])) : '';
                
                $user = $usersModel->where('user_type', 'Google')
                              ->groupStart()
                              ->where('user_email', $email)
                              ->orWhere('auth_id', $auth_id)
                              ->groupEnd()
                              ->first();
                              
                if (!$user) {

                    $data = [
                        'user_type'=>'Google',
                        'user_name' => addslashes(trim($get_helper['user_name'])),
                        'user_email' => addslashes(trim($get_helper['user_email'])),
                        'user_phone' => '',
                        'user_password' => PasswordVerify::defaultPassword(),
                        'user_gender'  => '',
                        'registered_on'  =>  strtotime(date('d-m-Y h:i:s A')),
                        'auth_id' => $auth_id,
                        'profile_img' => '',
                        'status'  =>  '1'
                    ];
                    
                    $usersModel->insert($data);
                    $user_id = $usersModel->getInsertID();
                    
                    $emailService = new EmailService();
                    $toName   = 'Recipient Register';
                    $subject = '[IMPORTANT] '.$this->settings['app_name'].' Registration Successful';
                    $msg  = '<tr>
                		<img src="'.base_url('images/'.$this->settings['app_logo']).'" alt="header" />
                		</br>
                		<h1>Hello! '.$user_name.'</h1>
                		<p>You have successfully registration with google</p>
                		<p>Thank you.</p>
                		';
                    if ($emailService->sendEmail($email, $toName, $subject, $msg)) {
                        
                    }
                    
                    $response = [
                        'user_id'     => strval($user_id),
                        'user_name'   => $get_helper['user_name'],
                        'user_email'  => $get_helper['user_email'],
                        'user_phone'  => '',
                        'user_gender' => '',
                        'profile_img' => '',
                        'auth_id'     => $auth_id,
                        'MSG'         => 'Login successfully.',
                        'success'     => '1'
                    ];
                } else {
                  
                    $data = array('auth_id'  =>  $auth_id); 
                    $usersModel->update($user['id'],$data );
                    $user_id = $user['id'];
                    
                    if($user['status'] == 0){
                        $response=array('msg' => 'Sorry ! Your account is suspended','success'=>'0');
                    } else {
                        $response = [
                            'user_id'    => $user['id'],
                            'user_name'  => $user['user_name'],
                            'user_email' => $user['user_email'],
                            'user_phone' => $user['user_phone'],
                            'user_gender'=> $user['user_gender'],
                            'profile_img'=> $user['profile_img'],
                            'auth_id'    => $auth_id,
                            'MSG'        => 'Login successfully.',
                            'success'    => '1'
                        ];
                    }
                }
                $this->updateActivityLog($user_id);
                
            } else if($user_type == 'Normal'){
                
                if (!filter_var($get_helper['user_email'], FILTER_VALIDATE_EMAIL)) {
                    $response = ['MSG' => $app_lang['invalid_email_format'], 'success' => '0'];
                } else {
                    
                    $user = $usersModel->where('user_email', $get_helper['user_email'])->first();
                    if ($user) {
                        $response = ['MSG' => 'Email is already exist !', 'success' => '0'];
                    } else {
                        
                        $imageName = $this->handleImageUpload();
                        $hashedPassword = PasswordVerify::hash(trim($get_helper['user_password']));
                        
                        $data = [
                            'user_name' => addslashes(trim($get_helper['user_name'])),
                            'user_email' => addslashes(trim($get_helper['user_email'])),
                            'user_phone' => addslashes(trim($get_helper['user_phone'])),
                            'user_password' => $hashedPassword,
                            'user_gender'  => addslashes(trim($get_helper['user_gender'])),
                            'registered_on'  =>  strtotime(date('d-m-Y h:i:s A')),
                            'profile_img' => $imageName,
                            'status'  =>  '1'
                        ];
                        
                        $usersModel->insert($data);
                        $user_id = $usersModel->getInsertID();
                        
                        $emailService = new EmailService();
                        $toName   = 'Recipient Register';
                        $subject = '[IMPORTANT] '.$this->settings['app_name'].' Registration Successful';
                        $msg  = '<tr>
                    		<img src="'.base_url('images/'.$this->settings['app_logo']).'" alt="header" />
                    		</br>
                    		<h1>Hello! '.$user_name.'</h1>
                    		<p>Your registration is successfully completed</p>
                    		<p>Thank you.</p>
                    		';
                        if ($emailService->sendEmail($email, $toName, $subject, $msg)) {
                            
                        }
                        
                        $response = ['MSG' => 'Registration successfully.', 'success' => '1'];
                        $this->updateActivityLog($user_id);
                    }
                }
                
            } else {
                $response = ['MSG' => 'Registration is failed !', 'success' => '0'];
            }
            $set[$this->apiHeader][] = $response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "user_login"){
            
            $response = [];
            
            $email=isset($get_helper['user_email']) ? trim($get_helper['user_email']) : '';
            $password=isset($get_helper['user_password']) ? trim($get_helper['user_password']) : '';
            $user_type=isset($get_helper['type']) ? trim($get_helper['type']) : '';
            
            
            $validation = \Config\Services::validation();
            $validation->setRules([
                'email' => 'required|valid_email',
            ]);

            if (!$validation->run(['email' => $email])) {
                $response=array('MSG' => 'Email format is invalid !','success'=>'0');
                $set[$this->apiHeader][]=$response;
                header( 'Content-Type: application/json; charset=utf-8' );
                echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
                die();
            }
            
            $usersModel = new UsersModel();
            
            if($user_type == 'Google'){
                $auth_id=isset($get_helper['auth_id']) ? trim($get_helper['auth_id']) : '';
                
                
                $user = $usersModel->groupStart()
                        ->where('user_email', $email)
                        ->orWhere('auth_id', $auth_id)
                        ->groupEnd()
                        ->groupStart()
                        ->where('LOWER(user_type)', 'google')
                        ->groupEnd()
                        ->first();

                if ($user) {
                    if ($user['status'] == 0) {
                        // If user account is deactivated
                        $response = ['MSG' => 'Sorry ! Your account is suspended', 'success' => '0'];
                    } else {
                        // Update activity log
                        $this->updateActivityLog($user['id']);
                        
                        // Update auth_id in the user record
                        $usersModel->update($user['id'], ['auth_id' => $auth_id]);
                        
                        // Return user details
                        $response = [
                            'user_id'    => $user['id'],
                            'user_name'  => $user['user_name'],
                            'user_phone' => $user['user_phone'],
                            'user_gender'=> $user['user_gender'],
                            'profile_img'=> base_url('images/' . $user['profile_img']),
                            'MSG'        => 'Login successfully.',
                            'success'    => '1'
                        ];
                    }
                } else {
                    // If user is not found
                    $response = ['MSG' => 'Email is not found !', 'success' => '0'];
                }
            } else if($user_type == 'Normal'){
                
                $user = $usersModel->where('user_email', $email)
                        ->groupStart()
                        ->where('LOWER(user_type)', 'normal')
                        ->groupEnd()
                        ->where('id !=', 0)
                        ->first();
                        
                if ($user) {
                    if ($user['status'] == 1) {
                        // Check if password matches
                        
                        if (PasswordVerify::verify($password, $user['user_password'])) {
                            // Update activity log
                            $this->updateActivityLog($user['id']);
                            
                            // Return response with user details
                            $response = [
                                'user_id'    => $user['id'],
                                'user_name'  => $user['user_name'],
                                'user_phone' => $user['user_phone'],
                                'user_gender'=> $user['user_gender'],
                                'profile_img'=> base_url('images/' . $user['profile_img']),
                                'MSG'        => 'Login successfully.',
                                'success'    => '1'
                            ];
                        } else {
                            // Invalid password
                            $response = ['MSG' => 'Password is invalid !', 'success' => '0'];
                        }
                    } else {
                        // Account deactivated
                        $response = ['MSG' => 'Sorry ! Your account is suspended', 'success' => '0'];
                    }
                } else {
                    // Email not found
                    $response = ['MSG' => 'Email is not found !', 'success' => '0'];
                }
            } else {
                $response = ['MSG' => 'Registration is failed !', 'success' => '0'];
            }
            $set[$this->apiHeader][] = $response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "user_profile") {
	
        	$jsonObj = [];
        	
        	$user_id = $get_helper['user_id'];
        	$usersModel = new UsersModel();
        	$user = $usersModel->find($user_id);
        	if ($user) {
        	    $data = [
                    'success' => "1",
                    'user_id' => $user['id'],
                    'user_name' => $user['user_name'],
                    'user_email' => !empty($user['user_email']) ? $user['user_email'] : '',
                    'user_phone' => !empty($user['user_phone']) ? $user['user_phone'] : '',
                    'user_gender' => $user['user_gender'],
                    'profile_img' => base_url('images/' . $user['profile_img']),
                ];
                array_push($jsonObj, $data);
        	} else {
        	    $jsonObj = ['MSG' => 'User not found.', 'success' => '0'];
        	}
            $set[$this->apiHeader] = $jsonObj;
        	header( 'Content-Type: application/json; charset=utf-8' );
        	echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE));
        	die();
        }
        else if($get_helper['helper_name'] == "edit_profile") {

            $response = [];

        	$user_id = $get_helper['user_id'];
        	$usersModel = new UsersModel();
        	$user = $usersModel->find($user_id);
        	if (!$user) {
        	    $response = ['MSG' => 'User not found', 'success' => '0'];
        	} else if (!filter_var($get_helper['user_email'], FILTER_VALIDATE_EMAIL)) {
        	    $response = ['MSG' => 'Email format is invalid!', 'success' => '0'];
        	} else if ($user['user_email'] == $get_helper['user_email'] && $user['id'] != $get_helper['user_id']) {
        	    $response = ['MSG' => 'Email is not found !', 'success' => '0'];
        	} else {
        	    
        	    $data = [
                    'user_name' => $get_helper['user_name'],
                    'user_email' => trim($get_helper['user_email']),
                    'user_phone' => $get_helper['user_phone'],
                ];
                
                // If password is provided, hash it and include it in the update
                if (!empty($get_helper['user_password'])) {
                    $hashedPassword = PasswordVerify::hash(trim($get_helper['user_password']));
                    $data['user_password'] = $hashedPassword;
                }
                
                $usersModel->update($user_id, $data);
                
                $response = ['MSG' => 'Updated successfully.', 'success' => '1'];
            }
            $set[$this->apiHeader][] = $response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "user_images_update"){
            
            $response = [];

            $user_id = $get_helper['user_id'];
            
            $imageName = $this->handleImageUpload();
            $data = ['profile_img' => $imageName];
            
            $usersModel = new UsersModel();
            $usersModel->update($user_id, $data);
            
            $response = ['MSG' => 'Updated successfully.', 'success' => '1'];
            
            $set[$this->apiHeader][] = $response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "account_delete"){
            
            $response = [];
            
            $usersModel = new UsersModel();
            $activeLogModel = new ActiveLogModel();
            $notificationModel = new NotificationModel();
            
            $user_id = $get_helper['user_id'];
            $user = $usersModel->find($user_id);
            if ($user) {
                // Check and delete profile image if exists
                if (!empty($user['profile_img'])) {
                    $imagePath = 'images/' . $user['profile_img'];
                    if (file_exists($imagePath)) {
                        unlink($imagePath);  // Delete the profile image
                    }
                }
                
                // Delete associated data in other tables (Active Log, Notifications)
                $activeLogModel->where('user_id', $user_id)->delete();
                $notificationModel->where('user_id', $user_id)->delete();
                
                // Delete user record
                $usersModel->delete($user_id);
                
                $response = ['MSG' => 'Account delete successfully.', 'success' => '1'];
            } else {
                $response = ['MSG' => 'User not found!', 'success' => '0'];
            }
            $set[$this->apiHeader][] = $response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        else if($get_helper['helper_name'] == "forgot_pass"){
            
            $response = [];
            
            $email=addslashes(trim($get_helper['user_email']));
            
            $usersModel = new UsersModel();
            $user = $usersModel->where('user_email', $email)
                        ->groupStart()
                        ->where('user_type', 'Normal')
                        ->orWhere('user_type', 'normal')
                        ->groupEnd()
                        ->where('id !=', 0)
                        ->first();
            if ($user) {
                
                $newPassword = bin2hex(random_bytes(4));
                $hashedPassword = PasswordVerify::hash($newPassword);
            
        		$recipient_name=$user['user_name'];
        		
        		$data = array(
                    'user_password'  =>  $hashedPassword
                );
                $usersModel->update($user['id'], $data);
                
                $emailService = new EmailService();
                $toName   = 'Recipient Password Reset';
                $subject = '[IMPORTANT] '.$this->settings['app_name'].' Your Password Reset';
                $msg  = '<tr>
            		<img src="'.base_url('images/'.$this->settings['app_logo']).'" alt="header" />
            		</br>
            		<h1>Hello! '.$user['user_name'].'</h1>
            		<p style="font-size: medium;">Your new password is:  <strong style="background-color: #e1e1e1; border-radius: 5px; 
            		color: #000; display: inline-block; font-weight: bold; padding-left: 10px; padding-right: 5px; padding-top: 5px; padding-bottom: 5px; font-size: large; letter-spacing: 5px;">
            		'.$newPassword.'
            		</strong></p>
            		<p>Please login and change your password immediately.</p>
            		<p>Thank you.</p>
            		';
                if ($emailService->sendEmail($user['user_email'], $toName, $subject, $msg)) {
                    $response = ['MSG' => 'Password has been sent on your mail.', 'success' => '1'];
                } else {
                    $response = ['MSG' => 'Password sent failed !', 'success' => '0'];
                }
            } else {
                $response = ['MSG' => 'Email is not found !', 'success' => '0'];
            }
            $set[$this->apiHeader][] = $response;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        }
        
        // Details -------------------------------------------------------------
        else if($get_helper['helper_name'] == "app_details") {
            
            // Details ---------------------------------------------------------
            $jsonObj= array();
            
            if($this->settings){
                
                // App Details ---------------------------------------------------------
                $row['app_email'] = $this->settings['app_email'];
                $row['app_author'] = $this->settings['app_author'];
                $row['app_contact'] = $this->settings['app_contact'];
                $row['app_website'] = $this->settings['app_website'];
                $row['app_description'] = $this->settings['app_description'];
                $row['app_developed_by'] = $this->settings['app_developed_by'];
                
                // Envato --------------------------------------------------------------
                $row['envato_api_key'] = $this->settings['envato_api_key'];
                
                // API Latest Limit ----------------------------------------------------
                $row['api_latest_limit'] = $this->settings['api_latest_limit'];
                
                // is ------------------------------------------------------------------
                $row['isRTL'] = $this->settings['isRTL'];
                $row['isMaintenance'] = $this->settings['isMaintenance'];
                $row['isScreenshot'] = $this->settings['isScreenshot'];
                $row['isGoogleLogin'] = $this->settings['isGoogleLogin'];
                $row['isLogin'] = $this->settings['isLogin'];
                $row['isAPK'] = $this->settings['isAPK'];
                $row['isVPN'] = $this->settings['isVPN'];
                
                $row['isDummy_1'] = $this->settings['isDummy_1'];
                $row['isDummy_2'] = $this->settings['isDummy_2'];
                $row['dummy_test_1'] = $this->settings['dummy_test_1'];
                $row['dummy_test_2'] = $this->settings['dummy_test_2'];
               
                // AppUpdate -----------------------------------------------------------
                $row['app_update_status'] = $this->settings['app_update_status'];
                $row['app_new_version'] = $this->settings['app_new_version'];
                $row['app_update_desc'] = $this->settings['app_update_desc'];
                $row['app_redirect_url'] = $this->settings['app_redirect_url'];
                
                // More Apps -----------------------------------------------------------
                $row['more_apps_url'] = $this->settings['more_apps_url'];
                
                // Ads Network ---------------------------------------------------------
                $row['ad_status'] = $this->settings['ad_status'];
                // PRIMARY ADS
                $row['ad_network'] = $this->settings['ad_network'];
                // admob
                $row['admob_publisher_id'] = $this->settings['admob_publisher_id'];
                $row['admob_banner_unit_id'] = $this->settings['admob_banner_unit_id'];
                $row['admob_interstitial_unit_id'] = $this->settings['admob_interstitial_unit_id'];
                $row['admob_native_unit_id'] = $this->settings['admob_native_unit_id'];
                $row['admob_app_open_ad_unit_id'] = $this->settings['admob_app_open_ad_unit_id'];
                $row['admob_reward_ad_unit_id'] = $this->settings['admob_reward_ad_unit_id'];
                // startapp
                $row['startapp_app_id'] = $this->settings['startapp_app_id'];
                // unity
                $row['unity_game_id'] = $this->settings['unity_game_id'];
                $row['unity_banner_placement_id'] = $this->settings['unity_banner_placement_id'];
                $row['unity_interstitial_placement_id'] = $this->settings['unity_interstitial_placement_id'];
                $row['unity_reward_ad_unit_id'] = $this->settings['unity_reward_ad_unit_id'];
                // applovin max
                $row['applovin_banner_ad_unit_id'] = $this->settings['applovin_banner_ad_unit_id'];
                $row['applovin_interstitial_ad_unit_id'] = $this->settings['applovin_interstitial_ad_unit_id'];
                $row['applovin_native_ad_manual_unit_id'] = $this->settings['applovin_native_ad_manual_unit_id'];
                $row['applovin_app_open_ad_unit_id'] = $this->settings['applovin_app_open_ad_unit_id'];
                $row['applovin_reward_ad_unit_id'] = $this->settings['applovin_reward_ad_unit_id'];
                // ironsource
                $row['ironsource_app_key'] = $this->settings['ironsource_app_key'];
                // Meta Audience Network
                $row['mata_banner_ad_unit_id'] = $this->settings['mata_banner_ad_unit_id'];
                $row['mata_interstitial_ad_unit_id'] = $this->settings['mata_interstitial_ad_unit_id'];
                $row['mata_native_ad_manual_unit_id'] = $this->settings['mata_native_ad_manual_unit_id'];
                // yandex
                $row['yandex_banner_ad_unit_id'] = $this->settings['yandex_banner_ad_unit_id'];
                $row['yandex_interstitial_ad_unit_id'] = $this->settings['yandex_interstitial_ad_unit_id'];
                $row['yandex_native_ad_manual_unit_id'] = $this->settings['yandex_native_ad_manual_unit_id'];
                $row['yandex_app_open_ad_unit_id'] = $this->settings['yandex_app_open_ad_unit_id'];
                // wortise
                $row['wortise_app_id'] = $this->settings['wortise_app_id'];
                $row['wortise_banner_unit_id'] = $this->settings['wortise_banner_unit_id'];
                $row['wortise_interstitial_unit_id'] = $this->settings['wortise_interstitial_unit_id'];
                $row['wortise_native_unit_id'] = $this->settings['wortise_native_unit_id'];
                $row['wortise_app_open_unit_id'] = $this->settings['wortise_app_open_unit_id'];
                $row['wortise_reward_ad_unit_id'] = $this->settings['wortise_reward_ad_unit_id'];
                
                // ADS PLACEMENT
                $row['banner_home'] = $this->settings['banner_home'];
                $row['banner_post_details'] = $this->settings['banner_post_details'];
                $row['banner_category_details'] = $this->settings['banner_category_details'];
                $row['banner_search'] = $this->settings['banner_search'];
                $row['interstitial_post_list'] = $this->settings['interstitial_post_list'];
                $row['native_ad_post_list'] = $this->settings['native_ad_post_list'];
                $row['native_ad_category_list'] = $this->settings['native_ad_category_list'];
                $row['app_open_ad_on_start'] = $this->settings['app_open_ad_on_start'];
                $row['reward_ad_on'] = $this->settings['reward_ad_on'];
                
                // GLOBAL CONFIGURATION
                $row['interstital_ad_click'] = $this->settings['interstital_ad_click'];
                $row['native_position'] = $this->settings['native_position'];
                $row['reward_credit'] = $this->settings['reward_credit'];
                
                 array_push($jsonObj,$row);
            }
            $set[$this->apiHeader] = $jsonObj;
            header( 'Content-Type: application/json; charset=utf-8' );
            echo $val= str_replace('\\/', '/', json_encode($set,JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
            die();
        } else {
            $get_helper = $this->getApiData($data); 
        }
    }
    
    private function handleImageUpload($existingImage = '') {
        $suffix = '_api_update';
        $file = $this->request->getFile('image_data');
        
        // Check if the file exists
        if (!$file) {
            return $existingImage; // Return the existing image if no file was uploaded
        }
        
        if ($file->isValid() && !$file->hasMoved()) {
            
            // Validate file type (only images allowed)
            if (!in_array($file->getMimeType(), ['image/jpeg', 'image/png', 'image/gif', 'image/svg+xml','image/webp', 'image/heic', 'image/heif'])) {
                return $existingImage; // Return existing image if the file is not an image
            }
            
            $imageDirectory = 'images/';
            
            // Check if the directory exists; if not, create it
            if (!is_dir($imageDirectory)) {
                mkdir($imageDirectory, 0777, true); // Create directory with proper permissions
            }
            
            // Delete existing image if it exists
            if ($existingImage && file_exists($imageDirectory . $existingImage)) {
                unlink($imageDirectory . $existingImage);
            }
            
            // Generate new image name with a suffix
            $extension = $file->getExtension(); // Get file extension
            $imageName = rand(0, 99999) . $suffix . '.' . $extension; // Append suffix
            
            // Move the file with the new name
            $file->move($imageDirectory, $imageName);
            
            return $imageName;
        }
        return $existingImage;
    }
    
    private function updateActivityLog($user_id) {
        $logModel = new ActiveLogModel();
        $log = $logModel->where('user_id', $user_id)->first();
        $timestamp = strtotime(date('d-m-Y h:i:s A'));
        if (!$log) {
            $data_log = ['user_id' => $user_id, 'date_time' => $timestamp];
            $logModel->insert($data_log);
        } else {
            $logModel->where('user_id', $user_id)->set(['date_time' => $timestamp])->update();
        }
    }

    private function getPaginationLimit($page, $page_limit = 15) {
        return ($page - 1) * $page_limit;
    }
    
    // Helper method to check purchase code validity
    private function isPurchaseCodeValid() {
        return !empty($this->settings['envato_buyer_name']) 
            && !empty($this->settings['envato_purchase_code']) 
            && !empty($this->settings['envato_api_key']);
    }

    // Separate method for handling the API data validation
    private function getApiData($data_info) {
        $data_json = $data_info;
        $data_arr = json_decode(urldecode(base64_decode($data_json)), true);
        
        // Validate the structure of the decoded data
        if (!isset($data_arr['application_id'])) {
            $set[$this->apiHeader][] = array('success' => '-1', "MSG" => 'Invalid data structure');
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            exit();
        }
        
        // Validate package name
        if ($data_arr['application_id'] != $this->settings['envato_package_name']) {
            $set[$this->apiHeader][] = array('success' => '-1', "MSG" => 'Invalid Package Name');
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($set, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
            exit();
        }
        
        return $data_arr;
    }
    
    // List --------------------------------------------------------------------
    private function getBannerList($result){
        $jsonObj = [];
        if (empty($result)) {
           return $jsonObj; 
        }
        foreach ($result as $data) {
            $jsonObj[] = [
                'bid'           => $data['bid'],
                'banner_title'  => $data['banner_title'],
                'banner_info'   => $data['banner_info'],
                'banner_image'  => base_url('images/' . $data['banner_image'])
            ];
        }
        return $jsonObj;
    }
    
    private function getRadioList($result, $user_id = 0){
        $jsonObj = [];
        if (empty($result)) {
           return $jsonObj; 
        }
        foreach ($result as $data) {
            $jsonObj[] = [
                'id'            => $data['id'],
                'cat_id'        => $data['cat_id'],
                'radio_title'   => $data['radio_title'],
                'radio_url'     => $data['radio_url'],
                'image'         => base_url('images/' . $data['radio_image']),
                'averageRating' => $data['rate_avg'],
                'totalRate'     => $data['total_rate'],
                'category_name' => $data['category_name'],
                'total_views'   => $data['total_views'],
                'is_premium'    => $data['isPremium'],
                'is_favourite'  => $this->favourite->is_favourite($data['id'], $user_id),
            ];
        }
        return $jsonObj;
    }
}